<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
{
    Schema::create('categories', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('slug')->unique(); // URL ke liye
        $table->unsignedBigInteger('parent_id')->nullable(); // Sub-category support (e.g., Result -> UP Board)
        $table->integer('priority')->default(0); // Admin me sort karne ke liye
        $table->boolean('status')->default(1); // 1=Active, 0=Hidden
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
