@extends('admin.layout')
@section('header', 'General Settings')

@section('content')

<form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data" class="max-w-4xl mx-auto">
    @csrf

    <div class="bg-white p-6 rounded shadow-lg mb-6">
        <h3 class="text-lg font-bold border-b pb-2 mb-4 text-blue-700">Site Identity</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block font-bold mb-1">Site Title</label>
                <input type="text" name="site_title" value="{{ $settings['site_title'] ?? '' }}" class="w-full border p-2 rounded">
            </div>

            <div>
                <label class="block font-bold mb-1">Footer Copyright Text</label>
                <input type="text" name="footer_text" value="{{ $settings['footer_text'] ?? '' }}" class="w-full border p-2 rounded">
            </div>
            
            <div class="md:col-span-2">
                <label class="block font-bold mb-1">Meta Description (SEO)</label>
                <textarea name="meta_description" rows="2" class="w-full border p-2 rounded">{{ $settings['meta_description'] ?? '' }}</textarea>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow-lg mb-6">
        <h3 class="text-lg font-bold border-b pb-2 mb-4 text-purple-700">Logo & Favicon</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block font-bold mb-1">Website Logo</label>
                <input type="file" name="site_logo" class="w-full border p-2 rounded bg-gray-50">
                @if(isset($settings['site_logo']))
                    <div class="mt-2 bg-gray-200 p-2 inline-block rounded">
                        <img src="{{ asset('storage/' . $settings['site_logo']) }}" alt="Logo" class="h-12">
                    </div>
                @endif
            </div>

            <div>
                <label class="block font-bold mb-1">Favicon (Browser Icon)</label>
                <input type="file" name="favicon" class="w-full border p-2 rounded bg-gray-50">
                @if(isset($settings['favicon']))
                    <div class="mt-2">
                        <img src="{{ asset('storage/' . $settings['favicon']) }}" alt="Favicon" class="h-8 w-8">
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow-lg mb-6">
        <h3 class="text-lg font-bold border-b pb-2 mb-4 text-green-700">Social & Extra</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block font-bold mb-1">Telegram Link</label>
                <input type="text" name="social_telegram" value="{{ $settings['social_telegram'] ?? '' }}" class="w-full border p-2 rounded text-blue-500">
            </div>

            <div>
                <label class="block font-bold mb-1">Facebook/YouTube Link</label>
                <input type="text" name="social_facebook" value="{{ $settings['social_facebook'] ?? '' }}" class="w-full border p-2 rounded text-blue-700">
            </div>
            
            <div class="md:col-span-2">
                <label class="block font-bold mb-1">Header Scripts (Google Analytics / Adsense)</label>
                <textarea name="header_script" rows="4" class="w-full border p-2 rounded font-mono text-sm bg-gray-900 text-green-400 placeholder-gray-500" placeholder="<script>...</script>">{{ $settings['header_script'] ?? '' }}</textarea>
            </div>
        </div>
    </div>

    <div class="text-center mb-10">
        <button type="submit" class="bg-blue-600 text-white font-bold py-3 px-10 rounded-lg hover:bg-blue-700 text-lg shadow">
            <i class="fas fa-save"></i> Save Settings
        </button>
    </div>

</form>

@endsection