<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>{{ get_setting('site_title', 'Sarkari Result 2026 - Latest Govt Jobs, Admit Card, Sarkari Naukri') }}</title>
    
    <meta name="description" content="{{ get_setting('meta_description', 'Sarkari Result 2026: India\'s No. 1 Job Portal for Latest Govt Jobs, Sarkari Naukri, Admit Card, 10th/12th Pass Jobs, Answer Key, and Result.') }}">
    
    <meta name="keywords" content="Sarkari Result, Sarkari Naukri, Govt Jobs 2026, Sarkari Exam, Admit Card, Result, 10th Pass Jobs, 12th Pass Jobs, Police Jobs, Railway Vacancy, SSC, Banking">
    
    <meta property="og:title" content="{{ get_setting('site_title', 'Sarkari Result 2026') }}" />
    <meta property="og:description" content="{{ get_setting('meta_description', 'Latest Govt Jobs & Sarkari Result Updates') }}" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="{{ url('/') }}" />
    @if(get_setting('site_logo'))
    <meta property="og:image" content="{{ get_setting('site_logo') }}" />
    @endif

    <script src="https://cdn.tailwindcss.com"></script>
    
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@500;700;800&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Roboto', sans-serif; background-color: #f0f2f5; }
        .hindi-text { font-family: 'Mukta', sans-serif; }
        
        .header-gradient { background: linear-gradient(180deg, #0056b3 0%, #003366 100%); }
        .btn-red { background: linear-gradient(to bottom, #dc2626, #b91c1c); border-bottom: 4px solid #991b1b; }
        .btn-red:active { transform: translateY(2px); border-bottom: 2px solid #991b1b; }
        .btn-search { background: linear-gradient(to bottom, #e11d48, #be123c); }
        .card-shadow { box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); }
        
        /* AD PLACEHOLDER STYLE */
        .ad-slot {
            background-color: #e5e7eb; /* Gray-200 */
            border: 2px dashed #9ca3af; /* Gray-400 */
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            width: 100%;
            margin-bottom: 1.5rem;
            overflow: hidden;
        }
    </style>
    
    {!! get_setting('header_script') !!}
</head>
<body class="bg-gray-100 antialiased">

    <nav class="bg-[#00284d] text-white shadow-lg border-b border-blue-900 sticky top-0 z-50">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="bg-white p-1 rounded">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-[#00284d]" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd" />
                    </svg>
                </div>
              <a href="{{ route('home') }}" class="flex items-center gap-2">
    @if(get_setting('site_logo'))
        <img src="{{ get_setting('site_logo') }}" alt="Logo" class="h-10">
    @else
        <span class="text-2xl md:text-3xl font-black tracking-wide uppercase text-yellow-400 drop-shadow-sm">
            {{ get_setting('site_name_first', 'JOB') }} <span class="text-white">{{ get_setting('site_name_second', 'UPDATE') }}</span>
        </span>
    @endif
</a>
            </div>
            <div class="hidden md:flex gap-8 text-lg font-medium">
                <a href="{{ route('home') }}" class="hover:text-yellow-400 transition">Home</a>
                <a href="{{ route('view.all', 'job') }}" class="hover:text-yellow-400 transition">Sarkari Jobs</a>
                <a href="{{ route('view.all', 'result') }}" class="hover:text-yellow-400 transition">Results</a>
                <a href="{{ route('view.all', 'admit_card') }}" class="hover:text-yellow-400 transition">Admit Cards</a>
            </div>
            <button class="md:hidden text-yellow-400">
                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path></svg>
            </button>
        </div>
    </nav>

<section class="header-gradient py-12 text-center text-white relative shadow-inner z-30">
    <div class="absolute bottom-0 left-0 w-full overflow-hidden leading-none z-0 pointer-events-none">
        <svg class="relative block w-full h-[30px]" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M1200 120L0 16.48 0 0 1200 0 1200 120z" class="fill-gray-100 opacity-10"></path>
        </svg>
    </div>

    <div class="relative z-10 container mx-auto px-4">
        <h1 class="text-4xl md:text-6xl font-extrabold hindi-text mb-3 text-yellow-400 drop-shadow-md leading-tight">
            सरकारी नौकरी <span class="text-white">और परीक्षा अपडेट</span>
        </h1>
        <p class="text-blue-100 text-lg md:text-xl mb-8 font-light">India's No. 1 Job Portal for Latest Govt Jobs & Exam Updates</p>

        <div class="max-w-3xl mx-auto relative overflow-visible"> 
            <form action="{{ route('search') }}" method="GET" class="flex bg-white rounded-lg p-1 shadow-2xl transform hover:scale-[1.01] transition duration-200">
                <input type="text" 
                       id="searchInput"
                       name="query" 
                       autocomplete="off" 
                       required
                       placeholder="Search Job Title, Result, Admit Card..." 
                       class="w-full px-5 py-4 text-gray-700 text-lg focus:outline-none rounded-l-lg">
                <button type="submit" class="btn-search text-white px-8 md:px-12 py-3 font-bold text-lg rounded-r-lg hover:brightness-110 transition shadow-md">
                    Search
                </button>
            </form>

            <div id="suggestionBox" class="absolute left-0 top-full w-full bg-white text-left text-gray-800 rounded-b-lg shadow-2xl border border-gray-200 z-[9999] hidden"></div>
        </div>
    </div>
</section>

    <div class="container mx-auto px-4 mt-6">
        <div class="ad-slot h-24 md:h-28">
            📢 ADVERTISEMENT (Top Banner) - Paste AdSense Code Here
        </div>
    </div>

    <div class="container mx-auto px-4 mt-2 relative z-20">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-6">
            <a href="{{ route('view.all', 'job') }}" class="bg-white rounded-xl card-shadow py-4 px-2 flex items-center justify-center gap-3 hover:-translate-y-1 transition duration-200 border-b-4 border-blue-600 group">
                <span class="text-2xl">💼</span>
                <span class="text-blue-900 font-bold text-lg group-hover:text-blue-700">Latest Jobs</span>
            </a>
            <a href="{{ route('view.all', 'admit_card') }}" class="bg-white rounded-xl card-shadow py-4 px-2 flex items-center justify-center gap-3 hover:-translate-y-1 transition duration-200 border-b-4 border-green-600 group">
                <span class="text-2xl">👤</span>
                <span class="text-green-900 font-bold text-lg group-hover:text-green-700">Admit Card</span>
            </a>
            <a href="{{ route('view.all', 'result') }}" class="bg-white rounded-xl card-shadow py-4 px-2 flex items-center justify-center gap-3 hover:-translate-y-1 transition duration-200 border-b-4 border-yellow-500 group">
                <span class="text-2xl">🏆</span>
                <span class="text-yellow-900 font-bold text-lg group-hover:text-yellow-700">Results</span>
            </a>
            <a href="{{ route('view.all', 'answer_key') }}" class="bg-white rounded-xl card-shadow py-4 px-2 flex items-center justify-center gap-3 hover:-translate-y-1 transition duration-200 border-b-4 border-purple-600 group">
                <span class="text-2xl">🔑</span>
                <span class="text-purple-900 font-bold text-lg group-hover:text-purple-700">Answer Key</span>
            </a>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-6">
        <div class="ad-slot h-20 md:h-24">
            📢 ADVERTISEMENT (Middle Banner)
        </div>
    </div>

    <div class="container mx-auto px-4 py-6">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="lg:col-span-2 space-y-8">
                
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    <div class="bg-gray-50 border-b border-gray-300 p-5 flex justify-between items-center">
                        <h2 class="text-2xl font-bold text-gray-800 border-l-8 border-blue-700 pl-3">Featured Govt Jobs</h2>
                        <span class="animate-pulse bg-red-100 text-red-700 border border-red-200 text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wider">Live Updates</span>
                    </div>

                    <div class="divide-y divide-gray-100">
                       @forelse($featured_jobs as $job)
                        <div class="p-5 hover:bg-blue-50 transition group cursor-pointer relative">
                            <a href="{{ route('post.detail', $job->slug) }}" class="block">
                                <h3 class="font-bold text-[#003366] group-hover:text-blue-600 text-xl mb-2">
                                    {{ $job->title }}
                                </h3>
                                <div class="flex flex-wrap items-center gap-x-4 gap-y-2 text-sm text-gray-600">
                                    <span class="flex items-center gap-1 bg-gray-100 px-2 py-1 rounded">
                                        🎓 {{ $job->post_name ?? 'Any Degree' }}
                                    </span>
                                    <span class="flex items-center gap-1 bg-gray-100 px-2 py-1 rounded">
                                        📄 {{ $job->total_vacancy ?? 'Various' }} Posts
                                    </span>
                                    <span class="ml-auto text-red-600 font-bold bg-red-50 px-2 py-1 rounded border border-red-100">
                                        Last Date: {{ $job->updated_at->format('d M Y') }}
                                    </span>
                                </div>
                            </a>
                        </div>
                        @empty
                        <div class="p-8 text-center text-gray-500 text-lg">No jobs currently available. Check back soon!</div>
                        @endforelse
                    </div>

                    <div class="p-4 bg-gray-50 text-center border-t border-gray-200">
                        <a href="{{ route('view.all', 'job') }}" class="btn-red text-white px-8 py-3 rounded-lg font-bold text-lg inline-block shadow-md hover:brightness-110 transition w-full md:w-auto">
                            View All Jobs &rarr;
                        </a>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white border rounded-lg shadow-md overflow-hidden">
                        <div class="bg-gradient-to-r from-blue-600 to-blue-800 text-white p-3 font-bold text-lg text-center shadow-sm">
                            ⬇️ Admit Cards
                        </div>
                        <ul class="divide-y divide-gray-100">
                            @foreach($admit_cards->take(6) as $card)
                            <li class="p-3 hover:bg-gray-50 transition">
                                <a href="{{ route('post.detail', $card->slug) }}" class="text-blue-700 font-medium hover:underline flex items-start gap-2">
                                    <span class="text-blue-400 mt-1">➤</span> {{ $card->title }}
                                </a>
                            </li>
                            @endforeach
                        </ul>
                        <div class="p-2 text-center bg-gray-50 border-t">
                            <a href="{{ route('view.all', 'admit_card') }}" class="text-sm font-bold text-blue-800 hover:text-blue-600">View All ></a>
                        </div>
                    </div>

                    <div class="bg-white border rounded-lg shadow-md overflow-hidden">
                        <div class="bg-gradient-to-r from-orange-500 to-red-600 text-white p-3 font-bold text-lg text-center shadow-sm">
                            🏆 Latest Results
                        </div>
                        <ul class="divide-y divide-gray-100">
                            @foreach($results->take(6) as $res)
                            <li class="p-3 hover:bg-gray-50 transition">
                                <a href="{{ route('post.detail', $res->slug) }}" class="text-red-700 font-medium hover:underline flex items-start gap-2">
                                    <span class="text-red-400 mt-1">➤</span> {{ $res->title }}
                                </a>
                            </li>
                            @endforeach
                        </ul>
                        <div class="p-2 text-center bg-gray-50 border-t">
                            <a href="{{ route('view.all', 'result') }}" class="text-sm font-bold text-red-800 hover:text-red-600">View All ></a>
                        </div>
                    </div>
                </div>

            </div>

            <div class="space-y-8">
                
                <div class="bg-white rounded-xl shadow-lg overflow-hidden border border-yellow-300">
                    <div class="bg-gradient-to-r from-yellow-100 to-yellow-200 p-4 border-b border-yellow-300">
                        <h2 class="text-xl font-extrabold text-gray-800 hindi-text flex items-center gap-2">
                            🔥 टॉप अपडेट्स <span class="text-sm font-normal text-gray-600">(Top Updates)</span>
                        </h2>
                    </div>
                    <ul class="divide-y divide-yellow-100">
                        @foreach($marquee_posts->take(6) as $update)
                        <li class="p-3 hover:bg-yellow-50 transition flex gap-3 items-start">
                            <div class="mt-1">
                                <span class="block w-2 h-2 bg-red-500 rounded-full animate-pulse"></span>
                            </div>
                            <a href="{{ route('post.detail', $update->slug) }}" class="text-[15px] font-semibold text-gray-700 hover:text-blue-700 leading-snug">
                                {{ $update->title }}
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>

                <div class="ad-slot h-64">
                    📢 SQUARE AD (Sidebar)
                </div>

                <div class="bg-white rounded-xl shadow-lg p-5 border border-gray-200">
                    <h2 class="text-lg font-bold text-gray-800 mb-4 border-l-4 border-blue-600 pl-3">Quick Links</h2>
                    <div class="grid grid-cols-2 gap-3">
                        <a href="{{ route('view.all', 'syllabus') }}" class="bg-blue-600 text-white py-3 text-center rounded-lg text-sm font-bold hover:bg-blue-700 shadow-md transition transform hover:scale-105">Syllabus</a>
                        <a href="{{ route('view.all', 'admit_card') }}" class="bg-blue-600 text-white py-3 text-center rounded-lg text-sm font-bold hover:bg-blue-700 shadow-md transition transform hover:scale-105">Admit Card</a>
                        <a href="{{ route('view.all', 'answer_key') }}" class="bg-blue-600 text-white py-3 text-center rounded-lg text-sm font-bold hover:bg-blue-700 shadow-md transition transform hover:scale-105">Answer Key</a>
                        <a href="{{ route('view.all', 'result') }}" class="bg-blue-600 text-white py-3 text-center rounded-lg text-sm font-bold hover:bg-blue-700 shadow-md transition transform hover:scale-105">Result</a>
                        <a href="#" class="col-span-2 bg-gradient-to-r from-purple-600 to-indigo-700 text-white py-3 text-center rounded-lg text-base font-bold shadow-md hover:shadow-lg transition">
                            📝 Free Mock Test Series
                        </a>
                    </div>
                </div>

                <div class="ad-slot h-96">
                    📢 VERTICAL AD (Sidebar)
                </div>

            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 pb-12">
        <div class="bg-gradient-to-r from-green-600 to-green-700 rounded-xl shadow-xl p-6 flex flex-col md:flex-row justify-between items-center gap-6 text-white border-b-4 border-green-800">
            <div class="flex items-center gap-4">
                <div class="bg-white p-2 rounded-full shadow-sm">
                    <svg class="w-8 h-8 text-green-600" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                </div>
                <div>
                    <h3 class="font-bold text-xl">Join WhatsApp Group</h3>
                    <p class="text-green-100 text-sm">Get Daily Job Alerts, Results & Admit Card Links</p>
                </div>
            </div>
            <button class="bg-yellow-400 text-green-900 px-8 py-3 rounded-full font-bold text-lg hover:bg-yellow-300 shadow-lg transition transform hover:scale-105">
                Join Now >
            </button>
        </div>
    </div>

    <div class="container mx-auto px-4 mb-6">
        <div class="ad-slot h-24">
            📢 ADVERTISEMENT (Bottom Banner)
        </div>
    </div>

<footer class="bg-[#00284d] text-white py-8 border-t-4 border-yellow-500">
    <div class="container mx-auto px-4 text-center">
        
        <div class="flex flex-wrap justify-center gap-4 mb-6 text-sm font-medium text-gray-300">
            <a href="{{ route('page.show', 'about-us') }}" class="hover:text-yellow-400 transition">About Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'contact-us') }}" class="hover:text-yellow-400 transition">Contact Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'privacy-policy') }}" class="hover:text-yellow-400 transition">Privacy Policy</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'disclaimer') }}" class="hover:text-yellow-400 transition">Disclaimer</a>
        </div>

        <p class="opacity-80">{!! get_setting('footer_text', '&copy; 2026 Job Update Portal. All rights reserved.') !!}</p>
    </div>
</footer>
    
<script>
    const searchInput = document.getElementById('searchInput');
    const suggestionBox = document.getElementById('suggestionBox');
    let timeout = null; 

    searchInput.addEventListener('input', function() {
        const query = this.value;
        clearTimeout(timeout);
        if (query.length < 2) {
            suggestionBox.classList.add('hidden');
            suggestionBox.innerHTML = '';
            return;
        }
        timeout = setTimeout(() => {
            fetchSuggestions(query);
        }, 300);
    });

    function fetchSuggestions(query) {
        fetch(`/ajax-search?query=${query}`)
            .then(response => response.json())
            .then(data => {
                if (data.length > 0) {
                    suggestionBox.classList.remove('hidden');
                    let html = '<ul class="divide-y divide-gray-100">';
                    data.forEach(post => {
                        let url = `/${post.slug}`;
                        let badgeColor = 'bg-gray-200 text-gray-600';
                        if(post.post_type === 'job') badgeColor = 'bg-blue-100 text-blue-700';
                        if(post.post_type === 'result') badgeColor = 'bg-red-100 text-red-700';
                        if(post.post_type === 'admit_card') badgeColor = 'bg-green-100 text-green-700';

                        html += `
                            <li>
                                <a href="${url}" class="block px-5 py-3 hover:bg-gray-50 transition flex justify-between items-center group">
                                    <span class="font-medium text-gray-700 group-hover:text-blue-600 truncate mr-2">${post.title}</span>
                                    <span class="text-xs px-2 py-1 rounded font-bold uppercase ${badgeColor}">${post.post_type.replace('_', ' ')}</span>
                                </a>
                            </li>
                        `;
                    });
                    html += '</ul>';
                    suggestionBox.innerHTML = html;
                } else {
                    suggestionBox.classList.add('hidden');
                }
            })
            .catch(error => console.error('Error:', error));
    }

    document.addEventListener('click', function(e) {
        if (!searchInput.contains(e.target) && !suggestionBox.contains(e.target)) {
            suggestionBox.classList.add('hidden');
        }
    });
</script>

</body>
</html>