<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>{{ $post->meta_title ?? $post->title }} - {{ get_setting('site_title') }}</title>
    <meta name="description" content="{{ $post->meta_desc ?? \Illuminate\Support\Str::limit($post->short_desc, 150) }}">
    
    <meta property="og:title" content="{{ $post->title }}" />
    <meta property="og:description" content="{{ \Illuminate\Support\Str::limit($post->short_desc, 100) }}" />
    <meta property="og:image" content="{{ get_setting('site_logo') }}" />
    <meta property="og:type" content="article" />

   

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@400;500;600;700&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Roboto', sans-serif; background-color: #f8f9fa; }
        .hindi-text { font-family: 'Mukta', sans-serif; }
        
        /* Table Styling */
        .content-area table { width: 100%; border-collapse: collapse; margin-bottom: 1.5rem; background-color: white; font-size: 0.95rem; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .content-area th { background-color: #dc2626; color: white; padding: 12px; border: 1px solid #b91c1c; text-align: left; font-weight: 700; text-transform: uppercase; font-size: 0.85rem; }
        .content-area td { padding: 12px; border: 1px solid #e5e7eb; color: #334155; vertical-align: top; }
        .content-area tr:nth-child(even) { background-color: #f8fafc; }
        .content-area tr:hover { background-color: #f1f5f9; }
        .content-area a { color: #1d4ed8; font-weight: 600; text-decoration: none; border-bottom: 1px dotted #1d4ed8; }
        .content-area a:hover { color: #dc2626; border-bottom: 1px solid #dc2626; }

        /* Ad Slot Styling */
        .ad-slot { background-color: #e5e7eb; border: 2px dashed #9ca3af; display: flex; align-items: center; justify-content: center; color: #6b7280; font-weight: bold; text-transform: uppercase; letter-spacing: 0.05em; width: 100%; margin-bottom: 1.5rem; overflow: hidden; text-align: center; font-size: 0.8rem; }
    </style>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">

    <nav class="bg-[#0f172a] text-white shadow-lg sticky top-0 z-50 border-b border-blue-900">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                <div class="bg-white p-1 rounded-sm group-hover:rotate-3 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-900" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd" /></svg>
                </div>
                <span class="text-2xl font-black uppercase text-yellow-400 tracking-tighter">
                    JOB <span class="text-white">UPDATE</span>
                </span>
            </a>
            <a href="{{ route('home') }}" class="text-sm font-bold bg-blue-600 px-4 py-2 rounded-lg hover:bg-blue-500 transition shadow-md flex items-center gap-1">Home</a>
        </div>
    </nav>

    <div class="bg-white border-b border-gray-200 shadow-sm">
        <div class="container mx-auto px-4 py-3">
            <nav class="flex text-sm text-gray-500" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="{{ route('home') }}" class="hover:text-blue-600 flex items-center">Home</a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <span class="text-gray-400">/</span>
                            <a href="{{ route('view.all', $post->post_type) }}" class="ml-1 hover:text-blue-600 capitalize">{{ str_replace('_', ' ', $post->post_type) }}</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <span class="text-gray-400">/</span>
                            <span class="ml-1 text-gray-700 font-medium truncate max-w-xs">{{ \Illuminate\Support\Str::limit($post->title, 30) }}</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-6">
        <div class="ad-slot h-24">📢 ADVERTISEMENT (Top Banner)</div>
    </div>

    <div class="container mx-auto px-4 py-8 flex-grow">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">

            <div class="lg:col-span-3">
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    
                    <div class="bg-gray-50 p-6 border-b border-gray-300 text-center relative">
                        <button onclick="window.print()" class="absolute top-4 right-4 text-gray-500 hover:text-blue-600 p-2 border rounded bg-white hidden md:block">🖨️</button>
                        <h1 class="text-2xl md:text-4xl font-extrabold text-red-700 mb-3 leading-tight hindi-text drop-shadow-sm">{{ $post->title }}</h1>
                        <div class="flex flex-wrap justify-center gap-4 text-sm font-medium text-gray-600">
                            <span>Post Date: <span class="text-gray-900">{{ $post->created_at->format('d M Y') }}</span></span>
                            <span>|</span>
                            <span>Updated: <span class="text-gray-900">{{ \Carbon\Carbon::parse($post->last_updated)->format('d M Y') }}</span></span>
                        </div>
                    </div>

                    <div class="px-6 py-4 bg-blue-50/50 border-b border-blue-100 text-center md:text-left">
                        <span class="text-blue-800 font-bold uppercase text-xs tracking-wider">Short Information</span>
                        <p class="text-gray-700 mt-1 leading-relaxed text-sm md:text-base">
                            {{ $post->short_desc ?? 'Read the full notification carefully before applying.' }}
                        </p>
                    </div>

                    <div class="p-4 md:p-8 content-area space-y-8">
                        
                        <div class="ad-slot h-20">📢 ADVERTISEMENT (Before Tables)</div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8">
                            @if($post->dates_content)
                            <div class="bg-white">
                                <h3 class="text-lg font-bold text-green-700 mb-3 uppercase flex items-center gap-2">📅 Important Dates</h3>
                                <div class="overflow-x-auto rounded border border-gray-200">{!! $post->dates_content !!}</div>
                            </div>
                            @endif
                            
                            @if($post->fees_content)
                            <div class="bg-white">
                                <h3 class="text-lg font-bold text-green-700 mb-3 uppercase flex items-center gap-2">₹ Application Fee</h3>
                                <div class="overflow-x-auto rounded border border-gray-200">{!! $post->fees_content !!}</div>
                            </div>
                            @endif
                        </div>

                        @if($post->age_content)
                        <div>
                            <h3 class="text-lg font-bold text-green-700 mb-3 uppercase flex items-center gap-2">👤 Age Limit</h3>
                            <div class="overflow-x-auto rounded border border-gray-200">{!! $post->age_content !!}</div>
                        </div>
                        @endif

                        @if($post->vacancy_content)
                        <div>
                            <h3 class="text-lg font-bold text-green-700 mb-3 uppercase flex items-center gap-2">📝 Vacancy Details</h3>
                            <div class="overflow-x-auto rounded border border-gray-200">{!! $post->vacancy_content !!}</div>
                        </div>
                        @endif
                        
                        <div id="links-section" class="mt-10">
                            <div class="text-center mb-6">
                                <h3 class="text-2xl md:text-3xl font-extrabold text-white bg-gradient-to-r from-blue-600 to-blue-800 py-3 rounded shadow-md uppercase tracking-wider inline-block w-full md:w-auto md:px-12">Important Links</h3>
                            </div>
                            
                            <div class="overflow-x-auto rounded-lg shadow-sm">
                                {!! $post->links_content !!}
                            </div>

                            <div class="mt-6 grid grid-cols-1 sm:grid-cols-2 gap-4">
                                @if($post->official_website)
                                <a href="{{ $post->official_website }}" target="_blank" class="flex items-center justify-center gap-2 bg-gray-800 hover:bg-gray-700 text-white py-3 font-bold rounded shadow transition">Official Website</a>
                                @endif
                                
                                @if($post->telegram_link)
                                <a href="{{ $post->telegram_link }}" target="_blank" class="flex items-center justify-center gap-2 bg-[#229ED9] hover:bg-[#1e8bc0] text-white py-3 font-bold rounded shadow transition">Join Telegram</a>
                                @endif
                            </div>
                        </div>

                        <div class="ad-slot h-24 mt-8">📢 ADVERTISEMENT (Bottom)</div>

                    </div>
                    
                    <div class="p-4 bg-yellow-50 text-xs text-yellow-800 text-center border-t border-yellow-100">
                        <strong>Disclaimer:</strong> Verify all details from official notification.
                    </div>
                </div>
            </div>

            <div class="hidden lg:block space-y-6">
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-4 text-center sticky top-24">
                    <p class="text-gray-600 font-bold text-sm mb-3">Join for Updates</p>
                    <div class="grid grid-cols-2 gap-2">
                        <a href="#" class="bg-green-50 text-green-700 p-3 rounded font-bold border border-green-200">WhatsApp</a>
                        <a href="#" class="bg-blue-50 text-blue-600 p-3 rounded font-bold border border-blue-200">Telegram</a>
                    </div>
                    <div class="mt-4"><div class="ad-slot h-64">📢 SIDEBAR AD</div></div>
                </div>
            </div>

        </div>
    </div>

    <footer class="bg-[#00284d] text-white py-8 mt-12 border-t-4 border-yellow-500">
        <div class="container mx-auto px-4 text-center">
            <div class="flex flex-wrap justify-center gap-4 mb-6 text-sm font-medium text-gray-300">
                <a href="{{ route('page.show', 'about-us') }}" class="hover:text-yellow-400">About Us</a>
                <span>|</span>
                <a href="{{ route('page.show', 'contact-us') }}" class="hover:text-yellow-400">Contact Us</a>
                <span>|</span>
                <a href="{{ route('page.show', 'privacy-policy') }}" class="hover:text-yellow-400">Privacy Policy</a>
                <span>|</span>
                <a href="{{ route('page.show', 'disclaimer') }}" class="hover:text-yellow-400">Disclaimer</a>
            </div>
            <p class="opacity-80">{!! get_setting('footer_text', '&copy; 2026 Job Update Portal. All rights reserved.') !!}</p>
        </div>
    </footer>

</body>
</html>