<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    @php
        $catTitle = ucfirst(str_replace('_', ' ', $type)); // e.g. Admit Card
        $currentYear = date('Y');
    @endphp

    <title>Latest {{ $catTitle }} {{ $currentYear }} - Download {{ $catTitle }} @ Sarkari-Result.site</title>
    
    <meta name="description" content="Check all latest {{ $catTitle }} for {{ $currentYear }}. Download PDF for Railway, SSC, Banking, Police and other Sarkari Exams at Sarkari-Result.site.">
    
    <meta name="keywords" content="{{ $catTitle }}, {{ $catTitle }} 2026, Sarkari {{ $catTitle }}, Govt Job {{ $catTitle }}">
  
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@400;500;600;700&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Roboto', sans-serif; background-color: #f8f9fa; }
        .hindi-text { font-family: 'Mukta', sans-serif; }
        /* Professional Gradient */
        .header-gradient { background: linear-gradient(135deg, #0f172a 0%, #1e40af 100%); }
        /* Smooth transition for cards */
        .job-card { transition: all 0.3s ease; }
        .job-card:hover { transform: translateY(-3px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }

        /* AD PLACEHOLDER STYLE */
        .ad-slot {
            background-color: #e5e7eb;
            border: 2px dashed #9ca3af;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            width: 100%;
            margin-bottom: 1.5rem;
            overflow: hidden;
            text-align: center;
            font-size: 0.8rem;
        }
    </style>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">

    <nav class="bg-[#0f172a] text-white shadow-lg sticky top-0 z-50 border-b border-blue-900">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                <div class="bg-white p-1 rounded-sm group-hover:rotate-3 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-900" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd" />
                    </svg>
                </div>
                <span class="text-2xl font-black uppercase text-yellow-400 tracking-tighter">
                    JOB <span class="text-white">UPDATE</span>
                </span>
            </a>
            <a href="{{ route('home') }}" class="text-sm font-bold bg-blue-600 px-4 py-2 rounded-lg hover:bg-blue-500 transition shadow-md flex items-center gap-1">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" /></svg>
                Home
            </a>
        </div>
    </nav>

    <div class="header-gradient text-white py-10 relative overflow-hidden shadow-md">
        <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
        
        <div class="container mx-auto px-4 relative z-10 text-center">
            <div class="inline-flex items-center gap-2 text-blue-200 text-sm mb-3 bg-white/10 px-3 py-1 rounded-full">
                <a href="{{ route('home') }}" class="hover:text-white">Home</a>
                <span>/</span>
                <span class="text-yellow-300 font-semibold">{{ $pageTitle }}</span>
            </div>
            <h1 class="text-4xl md:text-5xl font-extrabold uppercase tracking-wide drop-shadow-sm mb-2">
                {{ $pageTitle }} <span class="text-blue-300">Updates</span>
            </h1>
            <p class="text-blue-100 max-w-2xl mx-auto">Browse the latest list of {{ strtolower($pageTitle) }} and government notifications.</p>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-8">
        <div class="ad-slot h-24">
            📢 ADVERTISEMENT (Top Banner)
        </div>
    </div>

    <div class="container mx-auto px-4 py-4 flex-grow">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            
            <div class="lg:col-span-3">

                <div class="ad-slot h-20 mb-6">
                    📢 ADVERTISEMENT (Sponsored Listings)
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    
                    <div class="bg-gray-50 p-4 border-b border-gray-200 flex flex-wrap justify-between items-center gap-2">
                        <div class="flex items-center gap-2">
                            <span class="bg-blue-100 text-blue-800 text-xs font-bold px-2.5 py-0.5 rounded border border-blue-200">TOTAL: {{ $posts->total() }}</span>
                            <h2 class="font-bold text-gray-700 hidden sm:block">Latest Updates</h2>
                        </div>
                        <span class="text-xs text-gray-500 font-medium bg-white px-2 py-1 rounded border">
                            Page {{ $posts->currentPage() }} of {{ $posts->lastPage() }}
                        </span>
                    </div>

                    <div class="divide-y divide-gray-100">
                        @forelse($posts as $post)
                        <div class="job-card group relative p-5 bg-white hover:bg-blue-50/30 transition-all border-l-4 border-transparent hover:border-blue-600">
                            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                                
                                <div class="flex-1">
                                    <div class="flex items-start gap-3">
                                        <div class="mt-1 hidden sm:block">
                                            <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold text-lg">
                                                {{ substr($post->title, 0, 1) }}
                                            </div>
                                        </div>

                                        <div>
                                            <a href="{{ route('post.detail', $post->slug) }}" class="text-lg md:text-xl font-bold text-gray-800 group-hover:text-blue-700 leading-snug transition">
                                                {{ $post->title }}
                                            </a>
                                            
                                            <div class="flex flex-wrap items-center gap-3 mt-2 text-sm text-gray-500">
                                                <span class="flex items-center gap-1 bg-gray-100 px-2 py-0.5 rounded text-xs font-medium border border-gray-200">
                                                    📅 {{ $post->updated_at->format('d M, Y') }}
                                                </span>
                                                @if($post->post_name)
                                                <span class="flex items-center gap-1 bg-yellow-50 text-yellow-700 px-2 py-0.5 rounded text-xs font-medium border border-yellow-200">
                                                    🎓 {{ Str::limit($post->post_name, 20) }}
                                                </span>
                                                @endif
                                                
                                                @if($post->updated_at->diffInDays(now()) < 3)
                                                    <span class="text-[10px] font-bold bg-red-100 text-red-600 px-2 py-0.5 rounded-full animate-pulse">NEW</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <a href="{{ route('post.detail', $post->slug) }}" class="self-start md:self-center whitespace-nowrap px-5 py-2.5 bg-white border border-blue-600 text-blue-700 text-sm font-bold rounded-lg hover:bg-blue-600 hover:text-white transition shadow-sm flex items-center gap-2 group-hover:shadow-md">
                                    View Details 
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" /></svg>
                                </a>
                            </div>
                        </div>
                        @empty
                        <div class="p-12 text-center">
                            <div class="bg-gray-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-700">No Posts Found</h3>
                            <p class="text-gray-500 mt-2">We couldn't find any updates in this category right now.</p>
                            <a href="{{ route('home') }}" class="inline-block mt-4 text-blue-600 font-bold hover:underline">Go Back Home</a>
                        </div>
                        @endforelse
                    </div>

                    <div class="p-4 bg-gray-50 border-t border-gray-200">
                        {{ $posts->links() }} 
                    </div>
                </div>

                <div class="mt-8">
                    <div class="ad-slot h-24">
                        📢 ADVERTISEMENT (Bottom)
                    </div>
                </div>

            </div>

            <div class="hidden lg:block space-y-6">
                
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-4 text-center">
                    <p class="text-gray-600 font-bold text-sm mb-3">Join for Instant Updates</p>
                    <div class="grid grid-cols-2 gap-2">
                        <a href="#" class="flex flex-col items-center justify-center p-3 bg-green-50 text-green-700 rounded-lg hover:bg-green-100 transition border border-green-200">
                            <svg class="w-6 h-6 mb-1" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                            <span class="text-xs font-bold">WhatsApp</span>
                        </a>
                        <a href="#" class="flex flex-col items-center justify-center p-3 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition border border-blue-200">
                            <svg class="w-6 h-6 mb-1" fill="currentColor" viewBox="0 0 24 24"><path d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472-.18 1.898-.962 6.502-1.36 8.627-.168.9-.499 1.201-.82 1.23-.696.065-1.225-.46-1.9-.902-1.056-.693-1.653-1.124-2.678-1.8-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.386 4.025-1.627 4.476-1.635z"/></svg>
                            <span class="text-xs font-bold">Telegram</span>
                        </a>
                    </div>
                </div>

                <div class="ad-slot h-64">
                    📢 ADVERTISEMENT (Sidebar)
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="bg-gradient-to-r from-blue-900 to-blue-800 text-white p-3 font-bold text-center flex items-center justify-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                        Browse Categories
                    </div>
                    <div class="flex flex-col divide-y divide-gray-100">
                        <a href="{{ route('view.all', 'job') }}" class="p-3 hover:bg-blue-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>💼 Latest Jobs</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('view.all', 'admit_card') }}" class="p-3 hover:bg-green-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>👤 Admit Cards</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('view.all', 'result') }}" class="p-3 hover:bg-yellow-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>🏆 Results</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('view.all', 'answer_key') }}" class="p-3 hover:bg-purple-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>🔑 Answer Keys</span>
                            <span class="text-gray-400">›</span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>
    
   <footer class="bg-[#00284d] text-white py-8 mt-12 border-t-4 border-yellow-500">
    <div class="container mx-auto px-4 text-center">
        
        <div class="flex flex-wrap justify-center gap-4 mb-6 text-sm font-medium text-gray-300">
            <a href="{{ route('page.show', 'about-us') }}" class="hover:text-yellow-400 transition">About Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'contact-us') }}" class="hover:text-yellow-400 transition">Contact Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'privacy-policy') }}" class="hover:text-yellow-400 transition">Privacy Policy</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'disclaimer') }}" class="hover:text-yellow-400 transition">Disclaimer</a>
        </div>

        <p class="opacity-80">{!! get_setting('footer_text', '&copy; 2026 Job Update Portal. All rights reserved.') !!}</p>
    </div>
</footer>
</body>
</html>