<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SitemapController;
use App\Http\Controllers\AdminController; 
use App\Http\Controllers\AuthController; // <-- YE IMPORT MISSING THA

// --- 1. LOGIN & AUTH ROUTES (Sabse Pehle) ---
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// --- 2. ADMIN ROUTES (Protected) ---
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

    // Posts (CRUD)
    Route::get('/posts', [AdminController::class, 'posts'])->name('posts.index');
    Route::get('/posts/create', [AdminController::class, 'createPost'])->name('posts.create');
    Route::post('/posts/store', [AdminController::class, 'storePost'])->name('posts.store');
    Route::get('/posts/edit/{id}', [AdminController::class, 'editPost'])->name('posts.edit');
    Route::post('/posts/update/{id}', [AdminController::class, 'updatePost'])->name('posts.update');
    Route::get('/posts/delete/{id}', [AdminController::class, 'deletePost'])->name('posts.delete');

    // --- 3. CATEGORIES ROUTES ---
    Route::get('/categories', [AdminController::class, 'categories'])->name('categories.index');
    Route::post('/categories/store', [AdminController::class, 'storeCategory'])->name('categories.store');
    Route::get('/categories/edit/{id}', [AdminController::class, 'editCategory'])->name('categories.edit');
    Route::post('/categories/update/{id}', [AdminController::class, 'updateCategory'])->name('categories.update');
    Route::get('/categories/delete/{id}', [AdminController::class, 'deleteCategory'])->name('categories.delete');
    // --- 4. PAGES ROUTES ---
    Route::get('/pages', [AdminController::class, 'pages'])->name('pages.index');
    Route::get('/pages/create', [AdminController::class, 'createPage'])->name('pages.create');
    Route::post('/pages/store', [AdminController::class, 'storePage'])->name('pages.store');
    Route::get('/pages/edit/{id}', [AdminController::class, 'editPage'])->name('pages.edit');
    Route::post('/pages/update/{id}', [AdminController::class, 'updatePage'])->name('pages.update');
    Route::get('/pages/delete/{id}', [AdminController::class, 'deletePage'])->name('pages.delete');

    // --- 5. SETTINGS ROUTES ---
    Route::get('/settings', [AdminController::class, 'settings'])->name('settings.index');
    Route::post('/settings/update', [AdminController::class, 'updateSettings'])->name('settings.update');
});

// --- 3. SPECIFIC PUBLIC ROUTES ---
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/sitemap.xml', [SitemapController::class, 'index']);
Route::get('/search', [HomeController::class, 'search'])->name('search');
Route::get('/ajax-search', [HomeController::class, 'ajaxSearch'])->name('ajax.search');
Route::get('/view-all/{type}', [HomeController::class, 'viewAll'])->name('view.all');

// Storage Link Helper
Route::get('/run-storage-link', function () {
    $target = storage_path('app/public');
    $link = public_path('storage');
    if(file_exists($link)) return 'Link Already Exists';
    symlink($target, $link);
    return 'Storage Link Created Successfully!';
});

// --- 4. WILDCARD ROUTES (Ye Hamesha LAST Mein Rahenge) ---
// Dhyan rahe: Iske neeche koi aur route mat likhna

// Static Pages (e.g., /page/about-us)
Route::get('/page/{slug}', [HomeController::class, 'page'])->name('page.show');

// Post Detail (e.g., /up-police-constable) - CATCH ALL
Route::get('/{slug}', [HomeController::class, 'show'])->name('post.detail');